! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine inverse_mat1(mat_max,amat_in,A)

  implicit none
  integer, intent(in) :: mat_max
  complex(8), intent(in) :: amat_in(mat_max,mat_max)
  complex(8), intent(out) :: A(mat_max,mat_max)

  integer :: i1_do,i2_do,ier

  integer :: M, N, LDA, INFO, LWORK
  integer, allocatable :: IPIV(:)
  complex(8), allocatable :: WORK(:)

  do i2_do=1,mat_max
     do i1_do=1,mat_max
        A(i1_do,i2_do)=amat_in(i1_do,i2_do)
     end do
  end do

  allocate(IPIV(mat_max),WORK(mat_max),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: inverse_mat1 3'
     stop
  end if

  M=mat_max
  N=mat_max
  LDA=mat_max
  INFO=100
  call ZGETRF( M, N, A, LDA, IPIV, INFO )
  if( INFO /= 0 ) then
     write(*,*) 'error :: CGETRF',INFO
  end if

  LWORK=mat_max
  M=mat_max
  N=mat_max
  LDA=mat_max
  INFO=100
  call ZGETRI( N, A, LDA, IPIV, WORK, LWORK, INFO )
  if( INFO /= 0 ) then
     write(*,*) 'error :: CGETRI',INFO
  end if

  deallocate(IPIV,WORK,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: inverse_mat1 3'
     stop
  end if

  return
end subroutine inverse_mat1
