! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine get_negfordft(file_name,calc_t_negfordft)

  use mod_mpi

  implicit none
  character(50), intent(inout) :: file_name,calc_t_negfordft

  character(256) :: buf
  character(50) :: dummy1,dummy2
  character(50) :: tag1,tag2

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '********************** **************** **********************'
  write(16,*) '*               get condition // NEGF or DFT                 *'
  write(16,*) '*                      ++++++++++++++++                      *'
  close(16)

  !                       ------------------------------------                       !

  calc_t_negfordft=''
  open(unit=19,file=file_name,status='old')
  do 
     read(19,'(a)',end=100) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('general{')
        do 
           read(19,'(a)',end=100) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('dft__negf')
              read(buf,*) dummy1,dummy2,calc_t_negfordft
              go to 100
           case('}general')
              go to 100
           end select
        end do
     end select
  end do
100 continue
  close(19)
  if( calc_t_negfordft == "" ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '!!! broken !!! //general/dft__negf// => stop'
     close(17)
     stop
  end if

  open(unit=16,file=file_tempout,position='append')
  write(16,999) calc_t_negfordft
  write(16,*) '********************** **************** **********************'
  write(16,*)
  write(16,*)
  close(16)
999 format(' *                   condition ::  ',a10,'                 *')

  return
end subroutine get_negfordft
