! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine cal_gf_se_c_scf(ispin,kt)

  use scf_negf
  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use gf_se_c
  use constant
  use mod_mpi

  implicit none
  integer, intent(in) :: ispin,kt
  integer :: iw_do,i1_do,i2_do,i3_do,icou,i_w_st
  integer :: px,py,qx,qy
  complex(8) :: w,w_weight

  real(8) :: st1,st2,stdel,tot_t

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '         ------------ spin:',ispin,'------------'
  close(16)

  do i3_do=1,m_mat_max_c
     do i2_do=1,m_mat_max_c
        dens(ispin,i2_do,i3_do)=0.d0
        dens2(ispin,i2_do,i3_do)=0.d0
        edens(ispin,i2_do,i3_do)=0.d0
        edens2(ispin,i2_do,i3_do)=0.d0
     end do
  end do

  tot_t=0.d0

  if( ispin == 1 ) then
     i_w_st=myrank
  else
     i_w_st=myrank-mod(i_total_omega,nprocs)
     if( i_w_st < 0 ) then
        i_w_st=i_w_st+nprocs
     end if
  end if

  do iw_do=1+i_w_st,i_total_omega,nprocs

     open(unit=60,file=file_sf_scf(ispin,kt,iw_do))
     write(60,995) m_mat_max_c,i_total_omega
     close(60)

     w=omega_scf(iw_do)
     w_weight=omega_weight_scf(iw_do)

     !                       - - - - - - - - - - - - - - - - - -                       !

     call myclock(st1)

     open(unit=16,file=file_tempout,position='append')
     open(unit=60,file=file_sf_scf(ispin,kt,iw_do),position='append')
     write(60,997) w,w_weight,ispin
     close(60)
     do px=1,kx_max_ll                                           ! kx_max_ll = 1
        do py=1,ky_max_ll                                         ! ky_max_ll = 1
           call selfenergy_l(w,iw_do,px,py,ispin,kt)
           icou=0
           do i2_do=1,m_mat_max_c
              do i1_do=1,m_mat_max_c
                 if( se_l_mat_per(i1_do,i2_do,px,py) /= dcmplx(0.d0,0.d0) ) then
                    icou=icou+1
                 end if
              end do
           end do
           open(unit=60,file=file_sf_scf(ispin,kt,iw_do),position='append')
           write(60,*) icou
           do i2_do=1,m_mat_max_c
              do i1_do=1,m_mat_max_c
                 if( se_l_mat_per(i1_do,i2_do,px,py) /= dcmplx(0.d0,0.d0) ) then
                    write(60,999) i1_do,i2_do,se_l_mat_per(i1_do,i2_do,px,py)
                 end if
              end do
           end do
           close(60)

        end do
     end do
     close(16)

     call myclock(st2)
     stdel=st2-st1
     tot_t=tot_t+stdel

     call myclock(st1)

     open(unit=16,file=file_tempout,position='append')
     open(unit=60,file=file_sf_scf(ispin,kt,iw_do),position='append')
     write(60,998) w,w_weight,ispin
     close(60)
     do qx=1,kx_max_rr                                           ! kx_max_rr = 1
        do qy=1,ky_max_rr                                         ! ky_max_rr = 1
           call selfenergy_r(w,iw_do,qx,qy,ispin,kt)
           icou=0
           do i2_do=1,m_mat_max_c
              do i1_do=1,m_mat_max_c
                 if( se_r_mat_per(i1_do,i2_do,qx,qy) /= dcmplx(0.d0,0.d0) ) then
                    icou=icou+1
                 end if
              end do
           end do
           open(unit=60,file=file_sf_scf(ispin,kt,iw_do),position='append')
           write(60,*) icou
           do i2_do=1,m_mat_max_c
              do i1_do=1,m_mat_max_c
                 if( se_r_mat_per(i1_do,i2_do,qx,qy) /= dcmplx(0.d0,0.d0) ) then
                    write(60,999) i1_do,i2_do,se_r_mat_per(i1_do,i2_do,qx,qy)
                 end if
              end do
           end do
           close(60)

        end do
     end do
     close(16)

     call myclock(st2)
     stdel=st2-st1
     tot_t=tot_t+stdel

     call myclock(st1)

     open(unit=16,file=file_tempout,position='append')
     do px=1,kx_max_ll                                           ! kx_max_ll = 1
        do py=1,ky_max_ll                                         ! ky_max_ll = 1
           do qx=1,kx_max_rr                                       ! kx_max_rr = 1
              do qy=1,ky_max_rr                                     ! ky_max_rr = 1
                 call green_function_scf(w,w_weight,iw_do,px,py,qx,qy,ispin)
              end do
           end do
        end do
     end do
     close(16)

     call myclock(st2)
     stdel=st2-st1
     tot_t=tot_t+stdel

     !                       - - - - - - - - - - - - - - - - - -                        !

  end do

  call myclock(st1)
  call calc_edm(ispin)
  call myclock(st2)
  stdel=st2-st1
  tot_t=tot_t+stdel

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '                t=',tot_t
  close(16)

  !                       - - - - - - - - - - - - - - - - - -                        !

995 format(i10,i10)
997 format(d28.19,d28.19,d28.19,d28.19,i5                                        &
       ,'    ** left  *******************************')
998 format(d28.19,d28.19,d28.19,d28.19,i5                                        &
       ,'    ** right *******************************')
999 format(i10,i10,d28.19,d28.19)

  return
end subroutine cal_gf_se_c_scf

subroutine cal_gf_se_read_scf(ispin,kt)

  use scf_negf
  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use gf_se_c
  use constant
  use mod_mpi

  implicit none
  integer, intent(in) :: ispin,kt
  integer :: iw_do,i1_do,i2_do,i3_do,icou,i_total_omega_tt,i_w_st
  integer :: px,py,qx,qy
  integer :: m_mat_max_read,itemp
  real(8) :: temp1,temp2,temp3,temp4
  complex(8) :: w,w_weight,w1

  real(8) :: st1,st2,stdel,tot_t

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '         ------------ spin:',ispin,'------------'
  close(16)

  do i3_do=1,m_mat_max_c
     do i2_do=1,m_mat_max_c
        dens(ispin,i2_do,i3_do)=0.d0
        dens2(ispin,i2_do,i3_do)=0.d0
        edens(ispin,i2_do,i3_do)=0.d0
        edens2(ispin,i2_do,i3_do)=0.d0
     end do
  end do

  tot_t=0.d0

  if( ispin == 1 ) then
     i_w_st=myrank
  else
     i_w_st=myrank-mod(i_total_omega,nprocs)
     if( i_w_st < 0 ) then
        i_w_st=i_w_st+nprocs
     end if
  end if

  do iw_do=1+i_w_st,i_total_omega,nprocs

     open(unit=60,file=file_sf_scf(ispin,kt,iw_do))
     read(60,*) m_mat_max_read,i_total_omega_tt

     if( i_total_omega /= i_total_omega_tt ) then
        close(60)
        open(unit=16,file=file_tempout,position='append')
        write(16,*) 'error- (i_total_omega /= i_total_omega_t)',iw_do
        write(16,*) '                 re-cal.'
        close(16)
        stop
     end if

     itemp=m_mat_max_c-m_mat_max_read

     !                       - - - - - - - - - - - - - - - - - -                        !

     do px=1,kx_max_ll
        do py=1,ky_max_ll
           do i2_do=1,m_mat_max_c
              do i1_do=1,m_mat_max_c
                 se_l_mat_per(i1_do,i2_do,px,py)=dcmplx(0.d0,0.d0)
              end do
           end do
        end do
     end do

     read(60,996) temp1,temp2,temp3,temp4
     w=dcmplx(temp1,temp2)
     w_weight=dcmplx(temp3,temp4)
     do px=1,kx_max_ll
        do py=1,ky_max_ll
           read(60,*) icou
           do i3_do=1,icou
              read(60,999) i1_do,i2_do,temp1,temp2
              se_l_mat_per(i1_do,i2_do,px,py)=dcmplx(temp1,temp2)
           end do
        end do
     end do

     do qx=1,kx_max_rr
        do qy=1,ky_max_rr
           do i2_do=1,m_mat_max_c
              do i1_do=1,m_mat_max_c
                 se_r_mat_per(i1_do,i2_do,qx,qy)=dcmplx(0.d0,0.d0)
              end do
           end do
        end do
     end do

     read(60,996) temp1,temp2,temp3,temp4
     w1=dcmplx(temp1,temp2)
     if( w /= w1 ) then
        write(6,*) 'error--  w /= w1'
     end if
     do qx=1,kx_max_rr
        do qy=1,ky_max_rr
           read(60,*) icou
           do i3_do=1,icou
              read(60,999) i1_do,i2_do,temp1,temp2
              se_r_mat_per(itemp+i1_do,itemp+i2_do,qx,qy)=dcmplx(temp1,temp2)
           end do
        end do
     end do

     call myclock(st1)

     open(unit=16,file=file_tempout,position='append')
     do px=1,kx_max_ll
        do py=1,ky_max_ll
           do qx=1,kx_max_rr
              do qy=1,ky_max_rr
                 call green_function_scf(w,w_weight,iw_do,px,py,qx,qy,ispin)
              end do
           end do
        end do
     end do
     close(16)

     call myclock(st2)
     stdel=st2-st1
     tot_t=tot_t+stdel

     !                       - - - - - - - - - - - - - - - - - -                        !

  end do

  call myclock(st1)
  call calc_edm(ispin)
  call myclock(st2)
  stdel=st2-st1
  tot_t=tot_t+stdel

  close(60)

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '                t=',tot_t
  close(16)

  !                       - - - - - - - - - - - - - - - - - -                        !

996 format(d28.19,d28.19,d28.19,d28.19)
999 format(i10,i10,d28.19,d28.19)

  return
end subroutine cal_gf_se_read_scf
